local tau = math.pi*2

local scale = 10
local max_t = 1000
local steps = 500

function fmt(x)
	return string.format("%.2f", x)
end

for i=0, steps-1 do
	local t = i/steps
	local angle = math.cos(t * tau)

	-- construction the rotation quaternion
	local offset = 3*tau/8
	local c, s = math.cos((angle+offset)/2), math.sin((angle+offset)/2)
	local x = 0*s
	local y = 0*s
	local z = 1*s
	local w = c
	local rotation = "["..x..","..y..","..z..","..w.."]"

	-- construction the translation
	local x = -math.cos(angle+2*tau/8-0.08)*(0.5+1/16)*scale
	local y = -math.sin(angle+2*tau/8-0.08)*(0.5+1/16)*scale
	local z = 0.0
	local translation = "["..x..","..y..","..z.."]"

	-- transform the item display
	local nbt = "{start_interpolation:-1,transformation:{translation:"..translation..",left_rotation:"..rotation.."}}"
	local from_t = math.floor(max_t * t)
	local to_t = math.floor(max_t * (i+1)/steps)
	local frame_predicate = "if score @s axeAngle matches "..from_t..".."..to_t.." "
	print("execute "..frame_predicate.."run data merge entity @s "..nbt)

	-- handle player hitbox
	local hitbox_angle = math.cos((t-0.03) * tau)
	local hitbox_x = math.cos(hitbox_angle+6*tau/8)*0.95*scale
	local hitbox_y = math.sin(hitbox_angle+6*tau/8)*0.95*scale
	local hitbox_z = 0
	local positioning = "at @s positioned ~"..fmt(hitbox_x).." ~"..fmt(hitbox_y).." ~"..fmt(hitbox_z).." "
	-- print("execute "..positioning..frame_predicate.."run particle dust{color:[1.0,1.0,1.0],scale:0.5} ~ ~ ~ 0.5 0.5 0.5 0 1000")
	print("execute "..frame_predicate..positioning.."as @a[distance=..2.0] run kill @s")
	-- print("execute "..frame_predicate..positioning.."as @a[distance=..2.0] run say u dead x_x")
	-- print("execute "..frame_predicate..positioning.."as @a[distance=..2.0] at @s run playsound minecraft:entity.hurt master @s ~ ~ ~ 1 1")
end

--  /\_/\
-- ( o.o )
--  > ^ <
